﻿<?php
	include_once('header.php');
	$leaderboardsList = [];
	
	if ($stmt = $user_home->runQuery("SELECT * FROM leaderboards")) {
		while ($row = $stmt->fetch_array(MYSQLI_ASSOC)) {
			$leaderboardsList[] = $row;
		}
	}
?>
	<div id="message" style="display:none;">
		<div class="" id="alert">
			
		</div>
	</div>
      <div class="row">
			<div class="col-12">
				<div class="widget widget-table">
					<div class="widget-header"> <i class="icon-list-ol"></i>
						<h3> <?= $lang['leaderboards']; ?></h3>
						<?php if($user_home->is_logged_in()) { ?>
							<a href="addleaderboard.php" class="btn btn-danger btn-sm"><i class="icon-plus-sign"></i> <?= $lang['add_leaderboard']; ?></a>
						<?php } ?>
					</div>
					<div class="widget-content">
						<table class="table table-bordered table-striped table-hover"  id="paginated">
							<thead class="thead-inverse">
								<tr>
									<?php if($user_home->is_logged_in()) { ?>
										<th><?= $lang['id']; ?></th>
									<?php } ?>
                                    <th><?= $lang['leaderboard_name']; ?></th>
									<?php if($user_home->is_logged_in()) { ?>
										<th><?= $lang['leaderboard_token']; ?></th>
									<?php } ?>
                                    <th><?= $lang['leaderboard_reverse']; ?></th>
									<th class="td-actions" width="50%"> </th>
								</tr>
							</thead>
							<tbody>
							<?php if(count($leaderboardsList)==0) {
								if($user_home->is_logged_in()) {
									echo '<tr><td colspan="5"><div class="alert alert-danger">'.$lang["no_leaderboard"].'</div></td></tr>';
								} else {
									echo '<tr><td colspan="3"><div class="alert alert-danger">'.$lang["no_leaderboard"].'</div></td></tr>';
								}
							} ?>
                  <?php foreach ($leaderboardsList as $leaderboard) : ?>
							<tr id="row<?= $leaderboard['id']; ?>">
								<?php if($user_home->is_logged_in()) { ?>
									<td style="font-size: 15px;"><?= $leaderboard['id']; ?></td>
								<?php } ?>
                                <td style="font-size: 15px;" id="name<?= $leaderboard['id']; ?>"><?= $leaderboard['name']; ?></td>
								<?php if($user_home->is_logged_in()) { ?>
									<td style="text-align:left; direction: ltr; font-size: 15px;width: 150px;"><input type="text" id="token" value="<?= $leaderboard['token']; ?>" class="form-control" onclick="this.select();" readonly /></td>
								<?php } ?>
                                <td style="font-size: 15px;" id="reverse<?= $leaderboard['id']; ?>"><?php echo ($leaderboard['reverse'] == 1 ? $lang['low_to_high'] : $lang['high_to_low']); ?></td>
								<td>
									<a href="scores.php?id=<?= $leaderboard['id']; ?>" class="btn btn-primary btn-sm"><i class="icon-bar-chart"></i>&nbsp;&nbsp;<?= $lang['scores']; ?></i></a>
									<?php if($user_home->is_logged_in()) { ?>
										<a href="#" class="btn btn-primary btn-sm" id="addScore<?= $leaderboard['id']; ?>"><i class="icon-plus-sign"></i>&nbsp;&nbsp;<?= $lang['add_score']; ?></a>
<script type="text/javascript">
	$('#addScore<?= $leaderboard['id']; ?>').on("click", function () {
		$.confirm({
			title: "<?= $lang['add_score']; ?>",
			content: '' +
    '<form action="" class="formName">' +
    '<div class="form-group">' +
    '<label><?= $lang['player_name']; ?></label>' +
    '<input type="text" placeholder="<?= $lang['player_name']; ?>" class="name form-control" required />' +
	'<p class="errorName text-danger help-block" style="display:none;"></p>' +
    '<label><?= $lang['player_id']; ?></label>' +
    '<input type="text" placeholder="<?= $lang['player_id']; ?>" class="id form-control" required />' +
	'<p class="errorId text-danger help-block" style="display:none;"></p>' +
    '<label><?= $lang['score']; ?></label>' +
    '<input type="number" placeholder="<?= $lang['score']; ?>" class="score form-control" required />' +
	'<p class="errorScore text-danger help-block" style="display:none;"></p>' +
    '</div>' +
    '</form>',
			theme: 'bootstrap',
			buttons: {
				formSubmit: {
					text: "<?= $lang['add']; ?>",
					btnClass: "btn-primary",
					keys: [
						"enter",
						"shift"
					],
					action: function () {
						var name = this.$content.find('.name').val();
						var score = this.$content.find('.score').val();
						var id = this.$content.find('.id').val();
						if(!name){
							this.$content.find('.errorName').html('<?= $lang['player_name_empty']; ?>').slideDown(200);
							return false;
						}
						if(!id){
							this.$content.find('.errorId').html('<?= $lang['player_id_empty']; ?>').slideDown(200);
							return false;
						}
						if(!score){
							this.$content.find('.errorScore').html('<?= $lang['player_score_empty']; ?>').slideDown(200);
							return false;
						}
						add_score("<?= $leaderboard['id']; ?>", "<?= $leaderboard['token']; ?>", name, score, id, "<?= $_SESSION['lang']; ?>");
					}
				},
				Cancel: {
					text: "<?= $lang['cancel']; ?>",
					action: function () {}
				}
			}
		});
	});
</script>
		<button type="button" class="btn btn-warning btn-sm" id="edit_button<?= $leaderboard['id']; ?>" onclick="edit_leaderboard('<?= $leaderboard['id']; ?>', '<?= $language; ?>');"><i class="fa icon-edit"></i>&nbsp;&nbsp;<?= $lang['edit']; ?></button>
		<button type="button" class="btn btn-success btn-sm" style="display: none; margin-left: 3px;" id="save_button<?= $leaderboard['id']; ?>" onclick="save_leaderboard('<?= $leaderboard['id']; ?>', '<?= $language; ?>');"><i class="fa icon-save"></i>&nbsp;&nbsp;<?= $lang['save']; ?></button>
		<a href="#" class="btn btn-danger btn-sm" id="deleteApp<?= $leaderboard['id']; ?>"><i class="icon-trash"></i>&nbsp;&nbsp;<?= $lang['delete']; ?></a>
<script type="text/javascript">
	$('#deleteApp<?= $leaderboard['id']; ?>').on("click", function () {
		$.confirm({
			title: "<?= $lang['delete']; ?> <?= $leaderboard['name']; ?>!",
			content: "<?= $lang['delete_question']; ?>",
			theme: 'bootstrap',
			buttons: {
				Yes: {
					text: "<?= $lang['yes']; ?>",
					btnClass: "btn-blue",
					keys: [
						"enter",
						"shift"
					],
					action: function () {
						delete_leaderboard("<?= $leaderboard['id']; ?>", "<?= $leaderboard['token']; ?>", "<?= $_SESSION['lang']; ?>");
					}
				},
				Cancel: {
					text: "<?= $lang['cancel']; ?>",
					action: function () {}
				}
			}
		});
	});
</script>
	<?php } ?>
	</td>
	</tr>
	<?php endforeach; ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
	  </div>
<?php include_once('footer.php'); ?>